/********************************************************************************/
/*  t@C	F$Workfile: SddApi.h $											*/
/*  Tv		FOAPIwb_t@C											*/
/*  Copyright (c) 2003-2004 by Matsushita Electric Industrial Co., Ltd.			*/
/*  ŏIXV	F$Modtime: 04/01/23 17:13 $									*/
/********************************************************************************/

#ifndef _SDD_APIH_
#define _SDD_APIH_

#include "SddConfig.h"
#if defined(_SDD_LINUX_)
#if defined(_SDD_USE_ITRON_H_)
#include <itron.h>
#else
typedef signed char B;
typedef signed short H;
typedef signed long W;
typedef unsigned char UB;
typedef unsigned short UH;
typedef unsigned long UW;
typedef signed long ID;
typedef unsigned char BOOL;
#endif
typedef unsigned long long UDW;
#endif

/* SDD_HANDLE\ */
typedef struct {
	void *vp_Sdif;		/* SD I/F(SDD_DEV\)̃|C^ */
	UB ub_Port;			/* |[gԍi}`|[gΉłȂꍇ͖gpj */
}SDD_HANDLE;

/* ^` */
typedef W SDD_ERROR;
typedef void (* VOIDFP3)(UW, UW, UW);
typedef void (* VOIDFP1)(UW);
typedef W (* WFP1)(SDD_HANDLE *, UW);


/*==================*/
/* e̐ݒl */
/*==================*/

#define SDD_DEVICEID_PORTNUM_MASK  0xF0   /* foCXID Portԍ}XN */
#define SDD_DEVICEID_AREA_MASK     0x0F   /* foCXID ̈}XN */
#define SDD_DEVICEID_PORTNUM_SHIFT 4      /* foCXID Portԍ擾pVtg(4bit|[gԍ) */

/* foCXID(Port0) */
#define SDD_DEVICEID_NORMAL	(UW)0x01	/* foCXID(Port0)iʏ̈j*/
#define SDD_DEVICEID_SECURE	(UW)0x02	/* foCXID(Port0)iFؗ̈j*/

/* foCXID(Port1) */
#define SDD_DEVICEID_NORMAL_2 (UW)0x11	/* foCXID(Port1)iʏ̈j*/
#define SDD_DEVICEID_SECURE_2 (UW)0x12	/* foCXID(Port1)iFؗ̈j*/

/* foCXID(Port2) */
#define SDD_DEVICEID_NORMAL_3 (UW)0x21	/* foCXID(Port2)iʏ̈j*/
#define SDD_DEVICEID_SECURE_3 (UW)0x22	/* foCXID(Port2)iFؗ̈j*/

/* \tgZbg */
#define SDD_SOFT_RESET_ANGOU	(UW)0x01		/* ÍW[̃Zbg */
#define SDD_SOFT_RESET_SD		(UW)0x02		/* SD I/F̃Zbg */
#define SDD_SOFT_RESET_OTHER	(UW)0x04		/* ÍW[ȊỎH̃Zbg */
#define SDD_SOFT_RESET_ALL		(UW)0x07		/* SH̃Zbg */

/* SD I/F[hݒ */
#define SDD_MODE_NORMAL		(UW)1	/* ʏ탂[h */
#define SDD_MODE_STANDBY	(UW)2	/* X^oC[h(J[hoȊÕNbN~) */

/* CxgR[obN֐o^ */
#define SDD_EVENT_CARD_OUT			(UW)0x00000001	/* J[hro */
#define SDD_EVENT_CARD_IN			(UW)0x00000002	/* J[h} */
#define SDD_EVENT_ERROR				(UW)0x00000004	/* G[i񓯊G[j */
#ifdef _SDD_CALL_CBF_RETRY_INFO_
#define SDD_EVENT_ERR_RETRY_LBA		(UW)0x00000008	/* G[gC(LBAʒm) */
#define SDD_EVENT_ERR_RETRY_ERCD	(UW)0x00000010	/* G[gC(G[R[hʒm) */
#define SDD_EVENT_ERR_RETRY_INFO	(UW)0x00000020	/* G[gCIʒm(gCʒm) */
#define	SDD_EVENT_ALL				(UW)(SDD_EVENT_CARD_OUT | SDD_EVENT_CARD_IN | SDD_EVENT_ERROR | SDD_EVENT_ERR_RETRY_LBA | SDD_EVENT_ERR_RETRY_ERCD | SDD_EVENT_ERR_RETRY_INFO)	/* SCxg */

/* gC */
#define SDD_RETRY1_OK				(UB)0x01	/* gCPڂŐ */
#define SDD_RETRY2_OK				(UB)0x02	/* gCQڂŐ */
#define SDD_RETRY3_OK				(UB)0x03	/* gCRڂŐ */
#define SDD_RETRY0_NG				(UB)0xF0	/* G[ */
#define SDD_RETRY1_NG				(UB)0xF1	/* gCPڂŎs*/
#define SDD_RETRY2_NG				(UB)0xF2	/* gCQڂŎs*/
#define SDD_RETRY3_NG				(UB)0xF3	/* gCRڂs(ُP[X) */
#else
#define	SDD_EVENT_ALL				(UW)(SDD_EVENT_CARD_OUT | SDD_EVENT_CARD_IN | SDD_EVENT_ERROR)	/* SCxg */
#endif /* _SDD_CALL_CBF_RETRY_INFO_ */

/* J[h */
#define SDD_CARD_INIT_SOFT	(UW)0	/* ς݂Ȃ΃J[hȂ */
#define SDD_CARD_INIT_HARD	(UW)1	/* ς݂łJ[h */
#define SDD_CARD_INIT_MODE_MEMORY 0x00  /* [h */
#define SDD_CARD_INIT_MODE_SDIO   0x10  /* SDIO[h */
#define SDD_CARD_INIT_MODE_LV     0x20	/* d[h */
#define SDD_CARD_INIT_MODE_MASK   0x0F  /* INIT[h}XN */
#define SDD_CARD_MODE_MASK        0xF0  /* [h}XN */
#define SDD_CARD_INIT_SDIO_SOFT   (SDD_CARD_INIT_MODE_SDIO|SDD_CARD_INIT_SOFT)
#define SDD_CARD_INIT_SDIO_HARD   (SDD_CARD_INIT_MODE_SDIO|SDD_CARD_INIT_HARD)
#define SDD_CARD_INIT_LV_SOFT     (SDD_CARD_INIT_MODE_LV|SDD_CARD_INIT_SOFT)
#define SDD_CARD_INIT_LV_HARD     (SDD_CARD_INIT_MODE_LV|SDD_CARD_INIT_HARD)

/* J[h^Cv擾 */
#define	SDD_CARD_TYPE_UNKNOWN		(UW)0x00000000	/* m̃J[h(SuperSDJ[h͂̃^CvƂ݂Ȃ) */		
#define	SDD_CARD_TYPE_SD			(UW)0x00000001	/* SDJ[h */	
#define	SDD_CARD_TYPE_IO			(UW)0x00000002	/* SDIOJ[h */		
#define	SDD_CARD_TYPE_COMBO			(UW)(SDD_CARD_TYPE_SD | SDD_CARD_TYPE_IO)	/* SD COMBOJ[h */		
#define	SDD_CARD_TYPE_MMC			(UW)0x00000004	/* }`fBAJ[hiMMCAZLAMMCj */		
#define	SDD_CARD_TYPE_NOCARD		(UW)0x00000008	/* J[hȂ */		
#define	SDD_CARD_TYPE_ROM			(UW)0x00000010	/* ROMJ[h */	
#define	SDD_CARD_TYPE_PERFORMANCE	(UW)0x00000020	/* ptH[}XKΉJ[h */
#define	SDD_CARD_TYPE_NONSECURE     (UW)0x00000040	/* Fؗ̈揈ȂJ[h */
#define	SDD_CARD_TYPE_SDSPEC_VIOLATION  (UW)0x00000080	/* KiᔽJ[h */
#define	SDD_CARD_TYPE_SD_NONSECURE  (UW)(SDD_CARD_TYPE_SD | SDD_CARD_TYPE_NONSECURE) /* Fؗ̈揈ȂSDJ[h */
#define	SDD_CARD_TYPE_SD_ROM		(UW)(SDD_CARD_TYPE_SD | SDD_CARD_TYPE_ROM)	/* SD-ROMJ[h */	
#define	SDD_CARD_TYPE_SD_VIOLATION  (UW)(SDD_CARD_TYPE_SD | SDD_CARD_TYPE_SDSPEC_VIOLATION)	/* SDKiᔽJ[h */
#define	SDD_CARD_TYPE_MASK			(UW)0x0000000f	/* rbg}bv^Cv */
#define SDD_CARD_TYPE_OTP			(UW)0x00000100	/* OTPJ[h */
#define SDD_CARD_TYPE_UHS1			(UW)0x00000200	/* UHS-IΉJ[h */
#define SDD_CARD_TYPE_CLASS_RECORD	(UW)0x00000400	/* Xs[hNXL^ΉJ[h */

/* CgveNg`FbN */
#define SDD_WP_ALL				(UW)0x3f	/* `FbN\ȑSẴCgveNg */					
#define SDD_WP_MECHANICAL		(UW)0x01	/* J[h̃XChXCb` */	
#define SDD_WP_PERMANENT		(UW)0x02	/* CSDPERM_WRITE_PROTECT */
#define SDD_WP_TEMPORARY		(UW)0x04	/* CSDTMP_WRITE_PROTECT */
#define SDD_WP_CCC_BLOCK_WRITE	(UW)0x08	/* CSDCCC(Card Command Class)ɂClass4  (block write)T|[giCgveNgj */	
#define SDD_WP_CCC_ERASE		(UW)0x10	/* CSDCCC(Card Command Class)ɂClass5 (erase)T|[g iCgveNgj */		
#define SDD_WP_ROMCARD			(UW)0x20	/* ROMJ[h */	

/* SDfoCXhCoXe[^X擾 */
#define SDD_SDDDSTATUS_CARDTYPE_MASK	(UW)0x03f0	/* J[h^Cv */
#define SDD_SDDDSTATUS_STANBYMODE		(UW)0x0004	/* X^oC[h */
#define SDD_SDDDSTATUS_WP				(UW)0x0002	/* CgveNg */
#define SDD_SDDDSTATUS_CARD				(UW)0x0001	/* J[hL */

/* ʎ擾 */
#define SDD_RESULT_READ		(UH)0x01	/* ǂݍ݌ʁi[hAFؗ̈惊[hAUSBʏ̈惊[hAUSBFؗ̈惊[hAMKB擾̎sʁj */
#define SDD_RESULT_WRITE	(UH)0x02	/* ݌ʁiCgAFؗ̈惉CgAUSBʏ̈惉CgAUSBFؗ̈惉Cg̎sʁj */
#define SDD_RESULT_ERASE	(UH)0x04	/* ʁiʏ̈AFؗ̈̎sʁj */
#define SDD_RESULT_OTHER	(UH)0x08	/* ̑iSDfoCXhCoASDD_RESULT_READASDD_RESULT_WRITEASDD_RESULT_ERASÊɂΉ@\gpĂȂj */

/* GfBAݒ */
#define SDD_ENDIAN_CHANGE_OFF	(UW)0
#define SDD_ENDIAN_CHANGE_ON	(UW)1

/* R/WOEFCgݒ */
#define SDD_WAIT_DEFAULT	(UH)0x00
#define SDD_WAIT_READ		(UH)0x01
#define	SDD_WAIT_WRITE		(UH)0x02
#define SDD_WAIT_ALL		(UH)(SDD_WAIT_READ | SDD_WAIT_WRITE)

/* MCLK؂ւݒ */
#define SDD_MCLK_INTERNAL	(UB)0
#define SDD_MCLK_EXTERNAL	(UB)1

/* J[ht@NVݒ */
#define SDD_FUNC_SPEED_12	(UW)0x00	/* ]xől12.5MB/sɐݒ */
#define SDD_FUNC_SPEED_25	(UW)0x01	/* ]xől25MB/sɐݒ */
#define SDD_FUNC_SPEED_50	(UW)0x02	/* ]xől50MB/sɐݒ */

/* Xs[hNXL^ݒ */
#define SDD_START_RECORDING				(UW)0x00	/* Xs[hNXL^Jn */
#define SDD_CREAT_DIR					(UW)0x01	/* fBNgGg쐬 */
#define SDD_END_RECORDING_WITHOUT_MOVE	(UW)0x02	/* Xs[hNXL^IitOgǗȂj */
#define SDD_END_RECORDING_WITH_MOVE		(UW)0x03	/* Xs[hNXL^IitOgǗj */
#define SDD_UPDATE_CI					(UW)0x04	/* CIXV */

/* USBF؃p[^̎擾Aݒ */
#define SDD_HST_CMD_GET_MID	(UH)44
#define SDD_HST_CMD_SET_RANDOM	(UH)45
#define SDD_HST_CMD_GET_RANDOM	(UH)46
#define SDD_HST_CMD_SET_RESULT	(UH)47
#define SDD_HST_CMD_GET_RESULT	(UH)48

/* G[擾 */
#define SDD_ERR_NOERR	(UB)0x00
#define SDD_ERR_READ	(UB)0x01
#define SDD_ERR_WRITE	(UB)0x02
#define SDD_ERR_ERASE	(UB)0x04
#define SDD_ERR_OTHER	(UB)0x08
#define SDD_ERR_LEVEL0	(UB)0x00
#define SDD_ERR_LEVEL1	(UB)0x01
#define SDD_ERR_LEVEL2	(UB)0x02

/* SMARTR}hs */
#define SDD_SMART_READ		(UB)0x00
#define SDD_SMART_WRITE		(UB)0x01
#define SDD_SMART_PASSWORD	(UB)0x02

/*============================*/
/* OAPI o͐R}h */
/*============================*/

#define SDD_IOC_INIT					0x0000		/* SD foCXhCo */
#define SDD_IOC_SOFT_RESET				0x0001		/* SD I/F\tgZbg */
#define SDD_IOC_SET_MODE				0x0002		/* SD I/F[hݒ */
#define SDD_IOC_SET_CLOCK_DIV			0x0003		/* SDNbNݒ */
#define SDD_IOC_SET_RING_BUFF			0x0004		/* Oobt@ݒ */
#define SDD_IOC_SET_EVENT_CBF			0x0005		/* CxgR[obN֐o^ */
#define SDD_IOC_CARD_INIT				0x0006		/* J[h */
#define SDD_IOC_GET_CARD_TYPE			0x0007		/* J[h^Cv擾 */
#define SDD_IOC_GET_SECTOR_SIZE			0x0008		/* ZN^TCY擾 */
#define SDD_IOC_GET_CARD_CAPACITY		0x0009		/* J[hTCY擾 */
#define SDD_IOC_GET_AREA_SIZE			0x000a		/* ʏ̈TCY擾 */
#define SDD_IOC_ERASE					0x000b		/* ʏ̈ */
#define SDD_IOC_FLUSH_BUF				0x000c		/* obt@tbV */
#define SDD_IOC_CHECK_WP				0x000d		/* CgveNg`FbN */
#define SDD_IOC_GET_CARD_INFO			0x000e		/* J[h擾(CIDACSD擾) */
#define SDD_IOC_GET_STATUS				0x000f		/* SDfoCXhCoXe[^X擾 */
#define SDD_IOC_GET_CARD_STATUS			0x0010		/* J[hXe[^X擾 */
#define SDD_IOC_GET_SD_STATUS			0x0011		/* SDXe[^X擾 */
#define SDD_IOC_GET_RESULT				0x0012		/* ʎ擾 */
#define SDD_IOC_CANCEL					0x0013		/* LZ */
#define SDD_IOC_USB_READ				0x0014		/* USBʏ̈惊[h */
#define SDD_IOC_USB_WRITE				0x0015		/* USBʏ̈惉Cg */
#define SDD_IOC_USB_HST_GET				0x0016		/* USBF؃p[^擾 */
#define SDD_IOC_USB_HST_SET				0x0017		/* USBF؃p[^ݒ */
#define SDD_IOC_USB_SET_SECURE_AREA_SIZE	0x0018		/* USBFؗ̈TCYݒ */
#define SDD_IOC_USB_GET_MKB				0x0019		/* USB MKB擾 */
#define SDD_IOC_USB_SECURE_READ			0x001a		/* USBFؗ̈惊[h */
#define SDD_IOC_USB_SECURE_WRITE		0x001b		/* USBFؗ̈惉Cg */
#define SDD_IOC_ENDIAN					0x001c		/* EndianύX */
#define SDD_IOC_READ					0x001d		/* ʏ̈惊[h */
#define SDD_IOC_WRITE					0x001e		/* ʏ̈惉Cg@*/
#define SDD_IOC_VERSION					0x001f		/* SDDo[W擾 */
#define SDD_IOC_SET_RW_WAIT				0x0020		/* RWR}hsOEFCgݒ@*/
#define SDD_IOC_CHANGE_MCLK				0x0021		/* SD-IPMCLK̐؂ւ */
#define SDD_IOC_GET_EXT_CSD				0x0022		/* EXT-CSD擾iMMC Ver4.0ȏオΏہj*/
#define SDD_IOC_SET_CARDFUNC			0x0023		/* J[ht@NVݒ */
#define SDD_IOC_SPEEDCLASS_RECORDING	0x0024		/* Xs[hNXL^ݒ */
#define SDD_IOC_SETIO_READ_DIRECT       0x0025      /* CMD52 Reads */
#define SDD_IOC_SETIO_WRITE_DIRECT      0x0026      /* CMD52 Writes */
#define SDD_IOC_SETIO_READ_EXTENDED     0x0027      /* CMD53 }`ANZX[h */
#define SDD_IOC_SETIO_WRITE_EXTENDED    0x0028      /* CMD53 }`ANZXCg */
#define SDD_IOC_SET_BOOT_INFO			0x0029		/* Boot̐ݒ */
#define SDD_IOC_GET_ERRINFO				0x002A		/* G[擾 */
#define SDD_IOC_SEND_SMART				0x002B		/* SMARTR}hs */
#define SDD_IOC_SEND_COMMAND			0x002C		/* ėpR}hs */
#define SDD_IOC_GET_RCA                 0x002D      /* RCA擾 */
#define SDD_IOC_GET_SCR                 0x002E      /* SCR擾 */
#define SDD_IOC_READ_EXTR_SINGLE		0x002F      /* CMD48 Extension Register Reads */
#define SDD_IOC_WRITE_EXTR_SINGLE		0x0030      /* CMD49 Extension Register Writes */

#if defined _SDD_ANGOU_
#ifdef	_SDD_ANGOU_LASTFRAME_
#define SDD_CMD_MAX						0x0069		/* IOCTL̑ */
#else
#define SDD_CMD_MAX						0x0068		/* IOCTL̑ */
#endif	/* _SDD_ANGOU_LASTFRAME_ */
#elif defined _SDD_FUNC_SECURE_
#define SDD_CMD_MAX						0x0057		/* IOCTL̑ */
#else 
#define SDD_CMD_MAX						0x0031		/* IOCTL̑ */
#endif /* _SDD_ANGOU_ */

/*===============*/
/* MKBIDꗗ	 */
/*===============*/
#define	SDD_MKB0	0	/* MKB0 */
#define	SDD_MKB1	1	/* MKB1 */
#define	SDD_MKB2	2	/* MKB2 */
#define	SDD_MKB3	3	/* MKB3 */
#define	SDD_MKB4	4	/* MKB4 */
#define	SDD_MKB5	5	/* MKB5 */
#define	SDD_MKB6	6	/* MKB6 */
#define	SDD_MKB7	7	/* MKB7 */
#define	SDD_MKB8	8	/* MKB8 */
#define	SDD_MKB9	9	/* MKB9 */
#define	SDD_MKB10	10	/* MKB10 */
#define	SDD_MKB11	11	/* MKB11 */
#define	SDD_MKB12	12	/* MKB12 */
#define	SDD_MKB13	13	/* MKB13 */
#define	SDD_MKB14	14	/* MKB14 */
#define	SDD_MKB15	15	/* MKB15 */

/*===============*/
/* G[ꗗ	 */
/*===============*/

#define SDD_SUCCESS						(W)0x0000		/* I */
#define SDD_ERR_CTX						(W)0x0001		/* ReLXgG[ */
#define SDD_ERR_ALREADY_ATTACHED		(W)0x0002		/* ɃA^b`Ă */
#define SDD_ERR_NOT_ATTACHED			(W)0x0003		/* A^b`ĂȂ */
#define SDD_ERR_NOT_INIT				(W)0x0004		/* foCXhCoĂȂ */
#define SDD_ERR_ALREADY_OPENED			(W)0x0005		/* foCXɑ΂dI[v悤Ƃ */
#define SDD_ERR_NOT_OPENED				(W)0x0006		/* I[vĂȂ */
#define SDD_ERR_STATUS					(W)0x0007		/* ԃG[ */
#define SDD_ERR_ILLEGAL_ID				(W)0x0008		/* foCXIDs */
#define SDD_ERR_ILLEGAL_HANDLE			(W)0x0009		/* nhs */
#define SDD_ERR_PARAM					(W)0x000a		/* p[^G[ */
#define SDD_ERR_NOT_CARD_INIT			(W)0x000b		/* J[hĂȂ */
#define SDD_ERR_NO_CARD					(W)0x000c		/* J[hȂ */
#define SDD_ERR_CARD_OUT				(W)0x000d		/* ɃJ[hro */
#define SDD_ERR_STANDBY					(W)0x000e		/* X^oC[h */
#define SDD_ERR_R1_STATUS				(W)0x000f		/* R1X|XJ[hXe[^XG[ */
#define SDD_ERR_OCR_VDD					(W)0x0010		/* OCR VDDG[ */
#define SDD_ERR_CSD						(W)0x0011		/* CSD p[^G[ */
#define SDD_ERR_CARD_STATUS				(W)0x0012		/* J[hXe[^XG[ */
#define SDD_ERR_WP						(W)0x0013		/* CgveNg */
#define SDD_ERR_NUM_WR_SECTORS			(W)0x0014		/* ݊ZN^G[ */
#define SDD_ERR_RESET					(W)0x0015		/* J[hZbgR}h1.5b^CAEgG[ */
#define SDD_ERR_NOT_SUPPORT				(W)0x0016		/* T|[g */
#define SDD_ERR_ILMKBFORMAT				(W)0x0017		/* MKBtH[}bgُ */
#define SDD_ERR_ILMKBRECLEN				(W)0x0018		/* MKBtH[}bgُ */
#define SDD_ERR_MKBEND					(W)0x0019		/* MKBtH[}bgُ */
#define SDD_ERR_NOTHAVEMK				(W)0x001a		/* MKZoȑOɑݔF؂sĂ */
#define SDD_ERR_AUTH					(W)0x001b		/* ݔF؎s */
#define SDD_ERR_NOTLOCKED				(W)0x001c		/* bNĂȂMKB ID̉ */
#define SDD_ERR_OVERTRY					(W)0x001d		/* MKBd([jO) */
#define SDD_ERR_NODEVKEY				(W)0x001e		/* foCXL[擾foCX */
#define SDD_ERR_INIVALID_MKBID			(W)0x001f		/* MKB ID̎w */
#define SDD_ERR_LOCKED					(W)0x0020		/* MKBbNG[ */
#define SDD_ERR_UNCACHED				(W)0x0021		/* MKBbNG[ */
#define SDD_ERR_BADTARGET				(W)0x0022		/* ^[Qbgẅُ */
#define SDD_ERR_WRONG_KMU				(W)0x0024		/* sKMU */

/* 0x0023,0x0025,0x0026,0x0027,0x0028́ASddApi_secure.hɂĎgp */

#define SDD_ERR_SDMA_RSRC				(W)0x0030		/* SDMAC-Lib̃\[XG[iSDMAC_E_RSRCj */
#define SDD_ERR_SDMA_BUSY				(W)0x0031		/* SDMAC-Lib̓]G[iSDMAC_E_BUSYj */
#define SDD_ERR_SDMA_ERR				(W)0x0032		/* SDMAC-Lib̂̑G[iSDMAC_E_ERRj */

#define SDD_ERR_SDIO_R5_STATUS          (W)0x0033       /* R5 Status Error */
#define SDD_ERR_SDIO_CIS_TUPLE		    (W)0x0034       /* CIS that you want, not found error */
#define SDD_ERR_SDIO_READ_ERROR         (W)0x0035       /* READ Error */
#define SDD_ERR_SDIO_WRITE_ERROR        (W)0x0036       /* WRITE Error */
#define SDD_ERR_SDIO_INTR_ERROR         (W)0x0037       /* Intr Error */

/* 0x003A-0x003FɊւẮAPFˑG[i[ */

/* _aƂ邱Ƃ̂łG[[6:11] */
#define SDD_ERR_COMMAND					(W)0x0040		/* R}hG[ */
#define SDD_ERR_CRC						(W)0x0080		/* CRCG[ */
#define SDD_ERR_END						(W)0x0100		/* ENDG[ */
#define SDD_ERR_ILA						(W)0x0200		/* C[KANZXG[ */
#define SDD_ERR_IP_TIMEOUT				(W)0x0400		/* SD-IP̃^CAEgG[ */
#define SDD_ERR_OS_TIMEOUT				(W)0x0800		/* OS(-Itron)̃^CAEgG[ */
#define SDD_ERR_ACC_TIMEOUT				SDD_ERR_ILA		/* ANZX^CAEgG[(rW[) */

/* n[hEFAˑ̃G[i_aj*/
#define SDD_ERR_SDMA_STOP				(W)0x1000		/* 0oCg]SDMA~G[ */

#define SDD_ERR_MASK_SERIAL				(W)0x003f
#define	SDD_ERR_MASK_ERRBIT				(W)0x1fC0
#define SDD_ERR_MASK_HIGH				(W)0xffff0000
#define SDD_ERR_MASK_LOW				(W)0x0000ffff

/*================*/
/* e̍\ */
/*================*/
/* SDfoCXhCo */
typedef struct {
	VOIDFP3 vp_CardInFunc;	/* J[h}R[obN֐̃|C^ */
	UW uw_CardInParam;			/* J[h}R[obN֐ɓnCӂ̃f[^ */
	VOIDFP3 vp_CardOutFunc;	/* J[hroR[obN֐̃|C^ */
	UW uw_CardOutParam;			/* J[hroR[obN֐ɓnCӂ̃f[^ */
}SDD_INIT;


/* Oobt@ݒ */
typedef struct {
	UW uw_BuffStart;	/* obt@̈擪AhX */
	UW uw_BuffEnd;		/* obt@̈ŏIAhX */
	UW uw_OnOffFlg;		/* Oobt@@\ON/OFFtO */
}SDD_RING_BUFF;

/* CxgR[obN֐o^ */
typedef struct {
	UW uw_WaitEvent;		/* oCxg */
	VOIDFP3 vp_Fp;		/* R[obN֐̃|C^ */
	UW uw_Param;			/* R[obN֐ɓnCӂ̒l */
}SDD_EVENT_CBF;


/* ʏ̈ */
typedef struct {
	UW uw_Address;		/* JnZN^ */
	UW uw_Count;		/* ZN^ */
}SDD_ERASE;

/* CgveNg`FbN */
typedef struct {
	UW uw_CheckWP;		/* `FbN郉CgveNg */
	UW uw_Result;		/* `FbN */
}SDD_WP;

/* ʎ擾 */
typedef struct {
	UW			uw_Resid;		/* ZN^ */
	SDD_ERROR	w_Result;		/*  */
	UH			uh_Flag;		/* e */
}SDD_RESULT;

/* USBʏ̈惊[h,USBʏ̈惉Cg */
typedef struct {
	B *pb_Buff;			/* f[^i[|C^igpj */
	UW uw_Count;		/* RWZN^ */
	UW uw_Offset;		/* ItZbg(ZN^) */
}SDD_RW;

/* USBF؃p[^擾 */
typedef struct {
	UB *pub_Data;		/* F؃p[^ւ̃|C^ */
	UH uh_Size;		/* F؃p[^TCY */
	UH uh_Cmd;		/* F؃R}h */
}SDD_HST;

/* MKB擾 */
typedef struct {
	B *pb_Mkb;		/* MKBi[̃|C^ */
	UW uw_Count;	/* MKBǂݍ݃ZN^ */
	UW uw_Offset;	/* MKBǂݍ݊JnItZbg */
	UB ub_MKBId;	/* MKBID */
}SDD_GET_MKBID;

/* USBFؗ̈惊[h/Cg */
typedef struct {
	B *pb_Buff;		/* f[^i[|C^igpj */
	UW uw_Count;	/* RWZN^ */
	UW uw_Offset;	/* ItZbg(ZN^) */
	UB ub_MKBId;	/* MKBID */
	UB ub_Mode;		/* modeFSecureRead̎"0"ݒ肷邱 */
}SDD_SECURE_RW;

/* EFCgTCNݒ */
typedef struct {
	UW uw_Count;	/* [vTCN */
	UH uh_Flug;		/* EFCg}鏈e */
}SDD_WAIT;

typedef struct {
	UB ub_ErrProcess;	/* G[ */
	UB ub_ErrRank;		/* G[dvx */
	UH uh_Reserve1;		/* U[ü1 */
	UW uw_Offset;		/* vItZbg */
	UW uw_Size;			/* vTCY */
	UW uw_ErrOffset;	/* G[ItZbg */
	UW uw_Resid;		/* TCY */
	UW uw_Reserve2[4];		/* U[ü2 */
} SDD_ERR_INFO;

typedef struct {
	UB *pub_Arg;	/* A[Mg̈ւ̃|C^ */
	UB *pub_Data;	/* f[^̈ւ̃|C^ */
	UB ub_Type;		/*  */
} SDD_SMART_INFO;

typedef struct {
	UW uw_Cmd;		/* SD_CMDWX^ݒl */
	UW uw_Arg;		/* R}hA[Mg */
	UW uw_Size;		/* ]f[^TCY */
	UB *pub_Rsp;	/* X|Ẍւ̃|C^ */
	UB *pub_Data; 	/* f[^̈ւ̃|C^ */
} SDD_CMD_INFO;

#ifdef _SDD_FUNC_SDIO_
/* Read/Write DirectR}h */
typedef struct {
	UW uw_RegAddr;	  /* Register Address */
    UB ub_FuncNo;     /* FunctionNo */
	UB ub_Data;       /* Write/Read Data */
}SDD_SDIO_READWRITE;
typedef struct {
	UW uw_RegAddr;	  /* Register Address */
    UW uw_DataSize;   /* uw_DataSize */
	UB *pub_DataPtr;  /* Write/Read Data Pointer*/
    UH uh_OpCode;     /* OP Code */
    UB ub_FuncNo;     /* FunctionNo */
}SDD_SDIO_READWRITE_EXTENDED;
#define IO_ARG_OP_INC			0x0400	/* CMD53 Op Mode Increase Address */
#define IO_ARG_OP_FIX			0x0000	/* CMD53 Op Mode Fix Address */
#endif

#if	defined(_SDD_ENABLE_CMD48_CMD49_)
#define SDD_EXTR_MAX_DATA_SIZE			512		/* őANZXf[^TCY */
/* Extension Register Read/WriteR}h */
typedef struct {
	UW	uw_RegAddr;							/* In	WX^̃AhX */
	UB	ub_Data[SDD_EXTR_MAX_DATA_SIZE];	/* In	f[^i[̈|C^1 */
	UH	uh_DataSize;						/* In	ANZXf[^ (1`512bytes)2 */
											/* (MW = 1̂Ƃ 1byteŒƂȂÃGAbit7-0̓}XNo^[ƂȂB3) */
	UB	ub_MIO;								/* In	0:Memory 1:I/O  */
	UB	ub_MW;								/* In	Read:Reserved(gp) Write:Mask Write Operation (0: Disable 1: Enable) */
	UB	ub_FuncNo;							/* In	Function No */
}SDD_EXTR_READWRITE_SINGLE;
/* 1  Readf[^512bytesł_~[f[^ƕ512bytesi[܂B												*/
/*		Writef[^512bytesł_~[f[^ƕ512bytesǂݏo܂BWX^ɂuh_DataSizeԂ񏑂܂܂B	*/
/* 2  f[^|[gRead/Writeɂuh_DataSize = 1ɐݒ肷邱ƁBރf[^TCY 512bytesŒƂȂ܂B 		*/
/* 3  }XNp^[́f1fɂȂĂrbĝݏ܂܂B܂̂̓f[^i[̈̍ŏ1bytełA			*/
/*      _~[f[^ƕ512bytesǂݏo܂B																			*/

#define SDD_EXTR_ARG_MIO_MEM			0x00	/* CMD48/49 Memory Access */
#define SDD_EXTR_ARG_MIO_IO				0x01	/* CMD48/49 I/O Access */
#define SDD_EXTR_ARG_MW_NOMASKWRITE		0x00	/* CMD49 Mask Write Operation Disable */
#define SDD_EXTR_ARG_MW_MASKWRITE		0x01	/* CMD49 Mask Write Operation Enable */
#endif	/* defined(_SDD_ENABLE_CMD48_CMD49_) */

/*==========================*/
/*	֐̃vg^Cv錾	*/
/*==========================*/
extern void		 SDD_Init(void);
extern SDD_ERROR SDD_Attach(void);
extern SDD_ERROR SDD_Detach(void);
extern SDD_ERROR SDD_Open(UW uw_DevID, SDD_HANDLE *p_Handle);
extern SDD_ERROR SDD_Close(SDD_HANDLE *p_Handle);
extern SDD_ERROR SDD_Read(SDD_HANDLE *p_Handle, B *pb_Buff, UW uw_Count, UW uw_Offset);
extern SDD_ERROR SDD_Write(SDD_HANDLE *p_Handle, B *pb_Buff, UW uw_Count, UW uw_Offset);
extern SDD_ERROR SDD_Ioctl(SDD_HANDLE *p_Handle, UH uh_Cmd, UW uw_Arg, void *pv_Arg);

#ifdef _SDD_HWTIMER_SPEEDTEST_
/* HW^C}xpJE^ */
extern UW UwHwTimerStart1;                         /* HW^C}Jn_^C}l1 */
extern UW UwHwTimerStart2;                         /* HW^C}Jn_^C}l2 */
extern UW UwHwTimerStart3;                         /* HW^C}Jn_^C}l3 */
extern UW UwHwTimerEnd1;                           /* HW^C}I_^C}l1 */
extern UW UwHwTimerEnd2;                           /* HW^C}I_^C}l2 */
extern UW UwHwTimerEnd3;                           /* HW^C}I_^C}l3 */
#endif

#ifdef _SDD_DEBUG_REGISTER_
#define SDD_IOC_DEBUG_REGISTER				0xFF01		/* WX^Read/WriteR}h */
#define SDD_IOC_DEBUG_REGISTER_READ         0           /* Read */
#define SDD_IOC_DEBUG_REGISTER_WRITE        1           /* Write */
#define SDD_DEBUG
typedef struct {
	UW uw_RegAddr;	  /* Register Address */
	UH uh_Data;       /* Write/Read Data */
    UB ub_Direction;  /* FunctionNo */
}SDD_DEBUG_REGISTER;
#endif

/* Tuwb_t@C */
#if defined(_SDD_PEAKS_AVC_)
#include "SddApi_for_PeaksAVC.h"
#endif /* defined(_SDD_PEAKS_PRO2_) */

#if defined(_SDD_FUNC_SECURE_)
#include "SddApi_secure.h"
#endif /* _SDD_FUNC_SECURE_ */

#endif	/* _SDD_APIH_ */
